//GPT-4o-mini DATASET v1.0 Category: Bitwise operations ; Style: Dennis Ritchie
#include <stdio.h>

// Function to demonstrate bitwise operations: AND, OR, XOR, NOT, and left/right shifts
void bitwiseOperations(int a, int b) {
    printf("Operands: a = %d (%08b), b = %d (%08b)\n", a, a, b, b);
    
    // Bitwise AND
    int andResult = a & b;
    printf("Bitwise AND (a & b): %d (%08b)\n", andResult, andResult);
    
    // Bitwise OR
    int orResult = a | b;
    printf("Bitwise OR (a | b): %d (%08b)\n", orResult, orResult);
    
    // Bitwise XOR
    int xorResult = a ^ b;
    printf("Bitwise XOR (a ^ b): %d (%08b)\n", xorResult, xorResult);
    
    // Bitwise NOT
    printf("Bitwise NOT (~a): %d (%08b)\n", ~a, ~a);
    printf("Bitwise NOT (~b): %d (%08b)\n", ~b, ~b);
    
    // Left Shift
    printf("Left Shift (a << 1): %d (%08b)\n", a << 1, a << 1);
    printf("Left Shift (b << 1): %d (%08b)\n", b << 1, b << 1);
    
    // Right Shift
    printf("Right Shift (a >> 1): %d (%08b)\n", a >> 1, a >> 1);
    printf("Right Shift (b >> 1): %d (%08b)\n", b >> 1, b >> 1);
}

// Function to create masks and extract bits
void createMasksAndExtractBits(int num) {
    printf("\nExtracting bits from %d (%08b):\n", num, num);
    for (int i = 0; i < 8; i++) {
        int mask = 1 << i; // Create mask
        int extractedBit = (num & mask) >> i; // Extract the bit using the mask
        printf("Bit %d: %d\n", i, extractedBit);
    }
}

// Function to demonstrate usage of bitwise operations in an application
void applyBitwiseInApplication() {
    int value = 0b10101010; // Example binary value
    printf("\nStarting application with initial value: %d (%08b)\n", value, value);
    
    // Toggle the 2nd bit (index 1)
    value ^= (1 << 1);
    printf("Toggled 2nd bit: %d (%08b)\n", value, value);
    
    // Set the 5th bit (index 4)
    value |= (1 << 4);
    printf("Set 5th bit: %d (%08b)\n", value, value);
    
    // Clear the 6th bit (index 5)
    value &= ~(1 << 5);
    printf("Cleared 6th bit: %d (%08b)\n", value, value);
    
    // Check if the 3rd bit (index 2) is set
    if (value & (1 << 2)) {
        printf("The 3rd bit is set.\n");
    } else {
        printf("The 3rd bit is not set.\n");
    }
}

int main() {
    // Introduction
    printf("Bitwise Operations Demonstration\n");
    printf("---------------------------------\n");
    
    int a = 5;  // 0101 in binary
    int b = 3;  // 0011 in binary
    bitwiseOperations(a, b);
    
    // Create masks and extract bits from a value
    int num = 0b11001100;
    createMasksAndExtractBits(num);
    
    // Applying bitwise operations in a small application
    applyBitwiseInApplication();
    
    printf("\nEnd of Bitwise Operations Demonstration.\n");
    return 0;
}