//Falcon-180B DATASET v1.0 Category: Building a HTTP Client ; Style: Romeo and Juliet
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

#define BUFFER_SIZE 1024

// Function to write data to file
size_t WriteCallback(void *contents, size_t size, size_t nmemb, void *userp) {
    size_t realsize = size * nmemb;
    FILE *file = (FILE*)userp;
    return fwrite(contents, realsize, 1, file);
}

// Function to handle progress updates
int ProgressCallback(void *clientp, curl_off_t dltotal, curl_off_t dlnow, curl_off_t ultotal, curl_off_t ulnow) {
    double progress = (double)dlnow / dltotal * 100.0;
    printf("%.2f%%\r", progress);
    return 0;
}

// Main function to download a file using HTTP client
int main(int argc, char *argv[]) {
    if (argc!= 4) {
        printf("Usage: %s <url> <output file> <username:password>\n", argv[0]);
        return 1;
    }

    CURL *curl;
    FILE *file;
    CURLcode res;

    curl_global_init(CURL_GLOBAL_DEFAULT);
    curl = curl_easy_init();

    if (curl) {
        file = fopen(argv[2], "wb");
        if (!file) {
            printf("Failed to open output file.\n");
            curl_easy_cleanup(curl);
            curl_global_cleanup();
            return 1;
        }

        char *username_password = argv[3];
        curl_easy_setopt(curl, CURLOPT_URL, argv[1]);
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, file);
        curl_easy_setopt(curl, CURLOPT_PROGRESSFUNCTION, ProgressCallback);
        curl_easy_setopt(curl, CURLOPT_PROGRESSDATA, NULL);
        curl_easy_setopt(curl, CURLOPT_USERPWD, username_password);

        res = curl_easy_perform(curl);
        if (res!= CURLE_OK) {
            printf("HTTP client error: %s\n", curl_easy_strerror(res));
        } else {
            printf("\nFile downloaded successfully.\n");
        }

        fclose(file);
        curl_easy_cleanup(curl);
        curl_global_cleanup();
    } else {
        printf("Failed to initialize HTTP client.\n");
        return 1;
    }

    return 0;
}