//Falcon-180B DATASET v1.0 Category: Modern Encryption ; Style: immersive
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define KEY_SIZE 16
#define BLOCK_SIZE 8
#define ROUNDS 16

void generate_key(unsigned char key[KEY_SIZE]) {
    srand(time(NULL));
    for (int i = 0; i < KEY_SIZE; i++) {
        key[i] = rand() % 256;
    }
}

void encrypt(unsigned char key[KEY_SIZE], unsigned char plaintext[BLOCK_SIZE], unsigned char ciphertext[BLOCK_SIZE]) {
    for (int i = 0; i < BLOCK_SIZE; i++) {
        ciphertext[i] = plaintext[i] ^ key[i % KEY_SIZE];
    }
}

void decrypt(unsigned char key[KEY_SIZE], unsigned char ciphertext[BLOCK_SIZE], unsigned char plaintext[BLOCK_SIZE]) {
    for (int i = 0; i < BLOCK_SIZE; i++) {
        plaintext[i] = ciphertext[i] ^ key[i % KEY_SIZE];
    }
}

int main() {
    unsigned char key[KEY_SIZE];
    generate_key(key);

    printf("Key: ");
    for (int i = 0; i < KEY_SIZE; i++) {
        printf("%02X ", key[i]);
    }
    printf("\n");

    unsigned char plaintext[BLOCK_SIZE] = {0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF, 0x00, 0x11};
    unsigned char ciphertext[BLOCK_SIZE];

    encrypt(key, plaintext, ciphertext);

    printf("Plaintext: ");
    for (int i = 0; i < BLOCK_SIZE; i++) {
        printf("%02X ", plaintext[i]);
    }
    printf("\n");

    printf("Ciphertext: ");
    for (int i = 0; i < BLOCK_SIZE; i++) {
        printf("%02X ", ciphertext[i]);
    }
    printf("\n");

    decrypt(key, ciphertext, plaintext);

    printf("Decrypted text: ");
    for (int i = 0; i < BLOCK_SIZE; i++) {
        printf("%02X ", plaintext[i]);
    }
    printf("\n");

    return 0;
}