//Falcon-180B DATASET v1.0 Category: Networking ; Style: post-apocalyptic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>

#define BUFFER_SIZE 1024
#define SERVER_PORT 8080
#define SERVER_ADDRESS "127.0.0.1"

int main(int argc, char *argv[]) {
    int client_socket;
    struct sockaddr_in server_socket;
    char buffer[BUFFER_SIZE];
    int bytes_received;

    // Create socket
    client_socket = socket(AF_INET, SOCK_STREAM, 0);
    if (client_socket == -1) {
        printf("Error creating socket\n");
        exit(1);
    }

    // Connect to server
    server_socket.sin_family = AF_INET;
    server_socket.sin_port = htons(SERVER_PORT);
    inet_pton(AF_INET, SERVER_ADDRESS, &server_socket.sin_addr);

    if (connect(client_socket, (struct sockaddr *)&server_socket, sizeof(server_socket)) == -1) {
        printf("Error connecting to server\n");
        exit(2);
    }

    // Send message to server
    strcpy(buffer, "Hello, post-apocalyptic world!");
    bytes_received = send(client_socket, buffer, strlen(buffer), 0);

    // Receive message from server
    memset(buffer, 0, BUFFER_SIZE);
    bytes_received = recv(client_socket, buffer, BUFFER_SIZE, 0);

    // Print received message
    printf("Server response: %s\n", buffer);

    // Close socket
    close(client_socket);

    return 0;
}