//Falcon2-11B DATASET v1.0 Category: Scientific Calculator Implementation ; Style: shape shifting
#include <stdio.h>
#include <math.h>

int main() {
    // Create a structure to represent the calculator
    struct Calculator {
        char operator;
        double operand1, operand2;
    };

    struct Calculator calc;
    calc.operator = '+';
    calc.operand1 = 5.5;
    calc.operand2 = 2.0;

    // Print the original calculator
    printf("Original Calculator:\n");
    printf("Operator: %c\n", calc.operator);
    printf("Operand 1: %.2lf\n", calc.operand1);
    printf("Operand 2: %.2lf\n", calc.operand2);

    // Swap the operands
    double temp = calc.operand1;
    calc.operand1 = calc.operand2;
    calc.operand2 = temp;

    // Print the swapped calculator
    printf("\nSwapped Calculator:\n");
    printf("Operator: %c\n", calc.operator);
    printf("Operand 1: %.2lf\n", calc.operand1);
    printf("Operand 2: %.2lf\n", calc.operand2);

    // Calculate the result
    double result = 0;
    switch(calc.operator) {
        case '+':
            result = calc.operand1 + calc.operand2;
            break;
        case '-':
            result = calc.operand1 - calc.operand2;
            break;
        case '*':
            result = calc.operand1 * calc.operand2;
            break;
        case '/':
            if(calc.operand2 == 0) {
                printf("Error: Division by zero!\n");
                return 1;
            }
            result = calc.operand1 / calc.operand2;
            break;
        default:
            printf("Error: Invalid operator!\n");
            return 1;
    }

    // Print the result
    printf("\nResult: %.2lf\n", result);

    return 0;
}