//GEMINI-pro DATASET v1.0 Category: Text Summarizer ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SENTENCES 100
#define MAX_WORDS 100

typedef struct {
    char *word;
    int count;
} Word;

typedef struct {
    char *sentence;
    int score;
} Sentence;

int compare_sentences(const void *a, const void *b) {
    Sentence *sa = (Sentence *)a;
    Sentence *sb = (Sentence *)b;
    return sb->score - sa->score;
}

int main() {
    // Get the input text.
    char *text = NULL;
    size_t len = 0;
    getline(&text, &len, stdin);

    // Tokenize the text into sentences.
    Sentence sentences[MAX_SENTENCES];
    int num_sentences = 0;
    char *sentence = strtok(text, ".?!");
    while (sentence != NULL) {
        sentences[num_sentences].sentence = strdup(sentence);
        sentences[num_sentences].score = 0;
        num_sentences++;
        sentence = strtok(NULL, ".?!");
    }

    // Tokenize each sentence into words.
    Word words[MAX_WORDS];
    int num_words = 0;
    for (int i = 0; i < num_sentences; i++) {
        char *word = strtok(sentences[i].sentence, " ");
        while (word != NULL) {
            int found = 0;
            for (int j = 0; j < num_words; j++) {
                if (strcmp(word, words[j].word) == 0) {
                    words[j].count++;
                    found = 1;
                    break;
                }
            }
            if (!found) {
                words[num_words].word = strdup(word);
                words[num_words].count = 1;
                num_words++;
            }
            word = strtok(NULL, " ");
        }
    }

    // Calculate the score of each sentence.
    for (int i = 0; i < num_sentences; i++) {
        for (int j = 0; j < num_words; j++) {
            if (strstr(sentences[i].sentence, words[j].word) != NULL) {
                sentences[i].score += words[j].count;
            }
        }
    }

    // Sort the sentences by score.
    qsort(sentences, num_sentences, sizeof(Sentence), compare_sentences);

    // Print the summary.
    int num_sentences_to_print = num_sentences / 10;
    for (int i = 0; i < num_sentences_to_print; i++) {
        printf("%s\n", sentences[i].sentence);
    }

    // Free the memory.
    for (int i = 0; i < num_sentences; i++) {
        free(sentences[i].sentence);
    }
    for (int i = 0; i < num_words; i++) {
        free(words[i].word);
    }
    free(text);

    return 0;
}