//Falcon2-11B DATASET v1.0 Category: Matrix operations ; Style: Claude Shannon
#include <stdio.h>
#include <stdlib.h>

// Function to multiply two matrices
void matrixMultiply(int matrix1[3][3], int matrix2[3][3], int result[3][3]) {
    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            int sum = 0;
            for (int k = 0; k < 3; k++) {
                sum += matrix1[i][k] * matrix2[k][j];
            }
            result[i][j] = sum;
        }
    }
}

// Function to transpose a matrix
void transpose(int matrix[3][3], int transposed[3][3]) {
    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            int temp = matrix[i][j];
            matrix[i][j] = matrix[j][i];
            matrix[j][i] = temp;
        }
    }
    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            transposed[i][j] = matrix[i][j];
        }
    }
}

// Function to invert a matrix
int invertMatrix(int matrix[3][3], int inverse[3][3]) {
    int determinant = matrix[0][0] * matrix[1][1] * matrix[2][2] - matrix[0][1] * matrix[1][2] * matrix[2][0] + matrix[0][2] * matrix[1][0] * matrix[2][1] - matrix[0][2] * matrix[1][1] * matrix[2][0] - matrix[0][0] * matrix[1][2] * matrix[2][1] + matrix[0][0] * matrix[1][1] * matrix[2][2];
    if (determinant == 0) {
        printf("Matrix is singular, cannot invert\n");
        return 1;
    }
    int inverse_matrix[3][3];
    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            inverse_matrix[i][j] = (matrix[i][j] * (1.0 / determinant));
        }
    }
    return 0;
}

int main() {
    int matrix1[3][3] = { {1, 2, 3}, {4, 5, 6}, {7, 8, 9} };
    int matrix2[3][3] = { {1, 2, 3}, {4, 5, 6}, {7, 8, 9} };
    int result[3][3];
    int transposed[3][3];
    int inverse[3][3];

    matrixMultiply(matrix1, matrix2, result);
    transpose(matrix1, transposed);
    printf("Matrix Multiplication:\n");
    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            printf("%d ", result[i][j]);
        }
        printf("\n");
    }
    printf("\n");
    printf("Matrix Transpose:\n");
    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            printf("%d ", transposed[i][j]);
        }
        printf("\n");
    }
    printf("\n");
    invertMatrix(matrix1, inverse);
    printf("Matrix Inverse:\n");
    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            printf("%d ", inverse[i][j]);
        }
        printf("\n");
    }
    return 0;
}