//Falcon-180B DATASET v1.0 Category: Mailing list manager ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SUBSCRIBERS 1000
#define MAX_EMAIL_LENGTH 100
#define MAX_NAME_LENGTH 100

typedef struct {
    char name[MAX_NAME_LENGTH];
    char email[MAX_EMAIL_LENGTH];
} Subscriber;

Subscriber subscribers[MAX_SUBSCRIBERS];
int num_subscribers = 0;

void add_subscriber(char* name, char* email) {
    if (num_subscribers >= MAX_SUBSCRIBERS) {
        printf("Error: Maximum number of subscribers reached.\n");
        return;
    }

    strcpy(subscribers[num_subscribers].name, name);
    strcpy(subscribers[num_subscribers].email, email);
    num_subscribers++;
}

void remove_subscriber(char* email) {
    int i;

    for (i = 0; i < num_subscribers; i++) {
        if (strcmp(subscribers[i].email, email) == 0) {
            memset(&subscribers[i], 0, sizeof(Subscriber));
            num_subscribers--;
            printf("Subscriber %s removed from the list.\n", email);
            return;
        }
    }

    printf("Subscriber not found.\n");
}

void send_email(char* subject, char* message, char* from) {
    int i;

    printf("Sending email to %d subscribers:\n", num_subscribers);

    for (i = 0; i < num_subscribers; i++) {
        printf("  %s <%s>\n", subscribers[i].name, subscribers[i].email);
    }
}

int main() {
    add_subscriber("John Doe", "john@example.com");
    add_subscriber("Jane Doe", "jane@example.com");

    send_email("Test Email", "Hello, World!", "admin@example.com");

    remove_subscriber("john@example.com");

    send_email("Another Test Email", "Goodbye, World!", "admin@example.com");

    return 0;
}