//Code Llama-13B DATASET v1.0 Category: Text processing ; Style: detailed
/*
 * C Text processing example program
 *
 * This program demonstrates the use of C string functions to perform various text processing tasks.
 */

#include <stdio.h>
#include <string.h>

// Function to convert a string to uppercase
void str_toupper(char *str) {
    while (*str) {
        *str = toupper(*str);
        str++;
    }
}

// Function to convert a string to lowercase
void str_tolower(char *str) {
    while (*str) {
        *str = tolower(*str);
        str++;
    }
}

// Function to replace all occurrences of a character in a string
void str_replace(char *str, char old, char new) {
    while (*str) {
        if (*str == old) *str = new;
        str++;
    }
}

// Function to reverse a string
void str_reverse(char *str) {
    char *start = str;
    char *end = str + strlen(str) - 1;
    while (start < end) {
        char tmp = *start;
        *start = *end;
        *end = tmp;
        start++;
        end--;
    }
}

// Function to remove all whitespace characters from a string
void str_trim(char *str) {
    char *start = str;
    while (*start && isspace(*start)) start++;
    char *end = start + strlen(start) - 1;
    while (end > start && isspace(*end)) end--;
    *(end + 1) = '\0';
    memmove(str, start, end - start + 2);
}

int main() {
    char str1[] = "Hello, World!";
    char str2[] = "goodbye, world!";
    char str3[] = "The quick brown fox jumps over the lazy dog.";

    // Convert str1 to uppercase
    str_toupper(str1);
    printf("Uppercase: %s\n", str1);

    // Convert str2 to lowercase
    str_tolower(str2);
    printf("Lowercase: %s\n", str2);

    // Replace all occurrences of 'g' with 'g' in str3
    str_replace(str3, 'g', 'G');
    printf("Replace: %s\n", str3);

    // Reverse str3
    str_reverse(str3);
    printf("Reverse: %s\n", str3);

    // Trim whitespace from str3
    str_trim(str3);
    printf("Trim: %s\n", str3);

    return 0;
}