//Falcon-180B DATASET v1.0 Category: Database querying ; Style: imaginative
#include <stdio.h>
#include <stdlib.h>

// Define the structure of a record in our database
typedef struct {
    int id;
    char name[50];
    float price;
} Record;

// Define the structure of our database
typedef struct {
    int num_records;
    Record records[100];
} Database;

// Function to initialize the database with some sample data
void init_database(Database* db) {
    db->num_records = 5;
    strcpy(db->records[0].name, "Record 1");
    db->records[0].price = 10.5;
    db->records[0].id = 1;

    strcpy(db->records[1].name, "Record 2");
    db->records[1].price = 20.2;
    db->records[1].id = 2;

    strcpy(db->records[2].name, "Record 3");
    db->records[2].price = 30.7;
    db->records[2].id = 3;

    strcpy(db->records[3].name, "Record 4");
    db->records[3].price = 40.8;
    db->records[3].id = 4;

    strcpy(db->records[4].name, "Record 5");
    db->records[4].price = 50.1;
    db->records[4].id = 5;
}

// Function to query the database based on a given condition
void query_database(Database* db, char* condition) {
    printf("Querying the database: %s\n", condition);
    int num_results = 0;
    for (int i = 0; i < db->num_records; i++) {
        if (strcmp(db->records[i].name, condition) == 0) {
            printf("Record found: ID=%d, Name=%s, Price=%.2f\n", db->records[i].id, db->records[i].name, db->records[i].price);
            num_results++;
        }
    }
    if (num_results == 0) {
        printf("No record found.\n");
    }
}

// Main function to run the program
int main() {
    Database db;
    init_database(&db);

    printf("Initial database:\n");
    for (int i = 0; i < db.num_records; i++) {
        printf("ID=%d, Name=%s, Price=%.2f\n", db.records[i].id, db.records[i].name, db.records[i].price);
    }

    query_database(&db, "Record 2");

    return 0;
}