//Falcon-180B DATASET v1.0 Category: System process viewer ; Style: portable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/resource.h>

#define MAX_PROCESSES 100
#define MAX_PROCESS_NAME_LENGTH 100

typedef struct {
    pid_t pid;
    char name[MAX_PROCESS_NAME_LENGTH];
    int status;
} Process;

Process processes[MAX_PROCESSES];
int numProcesses = 0;

void updateProcesses() {
    DIR *dir;
    struct dirent *ent;
    char path[100];
    sprintf(path, "/proc");
    dir = opendir(path);

    if (dir!= NULL) {
        while ((ent = readdir(dir))!= NULL) {
            if (ent->d_type == DT_DIR) {
                int pid = atoi(ent->d_name);
                Process *process = &processes[numProcesses];
                process->pid = pid;
                sprintf(process->name, "Process %d", pid);
                process->status = 0;
                numProcesses++;
            }
        }
        closedir(dir);
    }
}

void displayProcesses() {
    printf("PID\tName\tStatus\n");
    for (int i = 0; i < numProcesses; i++) {
        printf("%d\t%s\t%d\n", processes[i].pid, processes[i].name, processes[i].status);
    }
}

void monitorProcesses() {
    while (1) {
        updateProcesses();
        displayProcesses();
        sleep(1);
    }
}

int main() {
    pid_t childPid;
    int status;

    childPid = fork();

    if (childPid == -1) {
        printf("Fork Failed\n");
        return 1;
    } else if (childPid == 0) {
        execlp("ls", "ls", NULL);
        printf("ls Exited\n");
        return 1;
    } else {
        waitpid(childPid, &status, WUNTRACED);
        printf("Child Process Exited\n");
        return 0;
    }
}