//Gemma-7B DATASET v1.0 Category: Stock market tracker ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_STOCK_NUM 10

typedef struct Stock {
    char name[20];
    double current_price;
    double previous_price;
    double change_percentage;
} Stock;

Stock stocks[MAX_STOCK_NUM];

void initializeStocks() {
    for (int i = 0; i < MAX_STOCK_NUM; i++) {
        stocks[i].name[0] = '\0';
        stocks[i].current_price = 0.0;
        stocks[i].previous_price = 0.0;
        stocks[i].change_percentage = 0.0;
    }
}

void updateStock(char *name, double current_price) {
    for (int i = 0; i < MAX_STOCK_NUM; i++) {
        if (strcmp(stocks[i].name, name) == 0) {
            stocks[i].current_price = current_price;
            stocks[i].previous_price = stocks[i].current_price;
            stocks[i].change_percentage = (current_price - stocks[i].previous_price) / stocks[i].previous_price * 100.0;
            return;
        }
    }

    // Stock not found, add new stock
    for (int i = 0; i < MAX_STOCK_NUM; i++) {
        if (stocks[i].name[0] == '\0') {
            strcpy(stocks[i].name, name);
            stocks[i].current_price = current_price;
            stocks[i].previous_price = current_price;
            stocks[i].change_percentage = 0.0;
            return;
        }
    }

    // No space for new stock
    printf("Error: No space for new stock.\n");
}

int main() {
    initializeStocks();

    // Update stock prices
    updateStock("Apple", 150.0);
    updateStock("Microsoft", 200.0);
    updateStock("Amazon", 120.0);

    // Print stock information
    for (int i = 0; i < MAX_STOCK_NUM; i++) {
        printf("%s: $%.2lf, %.2lf%% change\n", stocks[i].name, stocks[i].current_price, stocks[i].change_percentage);
    }

    return 0;
}