//GPT-4o-mini DATASET v1.0 Category: Classical Circuit Simulator ; Style: unmistakable
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct {
    char name[20];
    double resistance; // in Ohms
} Resistor;

typedef struct {
    char name[20];
    double capacitance; // in Farads
} Capacitor;

typedef struct {
    char name[20];
    double inductance; // in Henries
} Inductor;

typedef struct {
    Resistor *res1;
    Resistor *res2;
    char type[10]; // "series" or "parallel"
} ResistorNetwork;

void calculate_resistor_network(ResistorNetwork *network) {
    if (strcmp(network->type, "series") == 0) {
        double total_resistance = network->res1->resistance + network->res2->resistance;
        printf("Total Resistance in Series: %.2f Ohms\n", total_resistance);
    } else if (strcmp(network->type, "parallel") == 0) {
        double total_resistance = 1 / ((1 / network->res1->resistance) + (1 / network->res2->resistance));
        printf("Total Resistance in Parallel: %.2f Ohms\n", total_resistance);
    } else {
        printf("Invalid network type specified!\n");
    }
}

void simulate_capacitor(double capacitance, double voltage, double time) {
    double charge = capacitance * voltage * (1 - exp(-time / (capacitance * 1000.0))); // Discharge formula
    printf("Charge on the capacitor after %.2f seconds: %.5f Coulombs\n", time, charge);
}

void simulate_inductor(double inductance, double current, double time) {
    double voltage = inductance * (current / time); // Simple inductor formula
    printf("Voltage across the inductor after %.2f seconds: %.2f Volts\n", time, voltage);
}

int main() {
    Resistor r1, r2;
    strcpy(r1.name, "R1");
    r1.resistance = 100; // Ohms
    strcpy(r2.name, "R2");
    r2.resistance = 50; // Ohms

    ResistorNetwork network;
    network.res1 = &r1;
    network.res2 = &r2;
    strcpy(network.type, "series");

    calculate_resistor_network(&network);

    strcpy(network.type, "parallel");
    calculate_resistor_network(&network);

    Capacitor c1;
    strcpy(c1.name, "C1");
    c1.capacitance = 0.001; // Farads (1000uF)
    double voltage = 5.0; // Volts
    double time = 0.1; // seconds
    simulate_capacitor(c1.capacitance, voltage, time);

    Inductor l1;
    strcpy(l1.name, "L1");
    l1.inductance = 0.05; // Henries (50mH)
    double current = 2.0; // Amperes
    simulate_inductor(l1.inductance, current, time);

    return 0;
}