//GEMINI-pro DATASET v1.0 Category: Network Topology Mapper ; Style: Alan Turing
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>

#define MAX_INTERFACES 10

struct interface {
  char name[IFNAMSIZ];
  unsigned int index;
  unsigned int flags;
};

int main() {
  struct ifreq ifr[MAX_INTERFACES];
  struct interface interfaces[MAX_INTERFACES];
  int sockfd, i, j;

  sockfd = socket(AF_INET, SOCK_DGRAM, 0);
  if (sockfd < 0) {
    perror("socket");
    exit(EXIT_FAILURE);
  }

  for (i = 0; i < MAX_INTERFACES; i++) {
    snprintf(ifr[i].ifr_name, IFNAMSIZ, "eth%d", i);
    if (ioctl(sockfd, SIOCGIFINDEX, &ifr[i]) < 0) {
      perror("ioctl");
      exit(EXIT_FAILURE);
    }

    interfaces[i].index = ifr[i].ifr_ifindex;
    if (ioctl(sockfd, SIOCGIFFLAGS, &ifr[i]) < 0) {
      perror("ioctl");
      exit(EXIT_FAILURE);
    }

    interfaces[i].flags = ifr[i].ifr_flags;
  }

  close(sockfd);

  for (i = 0; i < MAX_INTERFACES; i++) {
    printf("%s: index %d, flags 0x%08x\n", interfaces[i].name, interfaces[i].index, interfaces[i].flags);
  }

  return EXIT_SUCCESS;
}