//Falcon2-11B DATASET v1.0 Category: Browser Plugin ; Style: modular
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#define BUFSIZE 1024

// Function to create a socket
int create_socket() {
    int sockfd;
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
        perror("Socket creation failed");
        exit(1);
    }
    return sockfd;
}

// Function to bind the socket
void bind_socket(int sockfd, const char *ip, int port) {
    struct sockaddr_in server_addr;
    server_addr.sin_family = AF_INET;
    server_addr.sin_addr.s_addr = inet_addr(ip);
    server_addr.sin_port = htons(port);
    if (bind(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) == -1) {
        perror("Binding failed");
        exit(1);
    }
}

// Function to listen on the socket
void listen_socket(int sockfd, int backlog) {
    if (listen(sockfd, backlog) == -1) {
        perror("Listen failed");
        exit(1);
    }
}

// Function to accept a connection
int accept_connection(int sockfd) {
    struct sockaddr_in client_addr;
    socklen_t client_len = sizeof(client_addr);
    int new_socket;
    if ((new_socket = accept(sockfd, (struct sockaddr *)&client_addr, &client_len)) == -1) {
        perror("Accept failed");
        exit(1);
    }
    return new_socket;
}

// Function to read from the socket
ssize_t read_socket(int sockfd, char *buf, size_t len) {
    ssize_t bytes_read = recv(sockfd, buf, len, 0);
    if (bytes_read < 0) {
        perror("Recv failed");
        exit(1);
    }
    return bytes_read;
}

// Function to write to the socket
ssize_t write_socket(int sockfd, const char *buf, size_t len) {
    ssize_t bytes_written = send(sockfd, buf, len, 0);
    if (bytes_written < 0) {
        perror("Send failed");
        exit(1);
    }
    return bytes_written;
}

// Function to close the socket
void close_socket(int sockfd) {
    if (close(sockfd) == -1) {
        perror("Close failed");
        exit(1);
    }
}

int main() {
    int sockfd, new_socket;
    socklen_t client_len;
    char buf[BUFSIZE];

    // Create socket
    sockfd = create_socket();
    if (sockfd < 0) {
        perror("Socket creation failed");
        exit(1);
    }

    // Bind socket
    const char *ip = "127.0.0.1";
    int port = 8080;
    bind_socket(sockfd, ip, port);

    // Listen on socket
    int backlog = 5;
    listen_socket(sockfd, backlog);

    // Accept a connection
    new_socket = accept_connection(sockfd);
    if (new_socket < 0) {
        perror("Accept failed");
        exit(1);
    }

    // Read from socket
    read_socket(new_socket, buf, BUFSIZE);
    printf("Received: %s\n", buf);

    // Write to socket
    ssize_t len = snprintf(buf, BUFSIZE, "Hello, world!");
    write_socket(new_socket, buf, len);
    printf("Sent: %s\n", buf);

    // Close socket
    close_socket(new_socket);
    close_socket(sockfd);

    return 0;
}