//GEMINI-pro DATASET v1.0 Category: Haunted House Simulator ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the maximum number of rooms in the haunted house
#define MAX_ROOMS 10

// Define the possible states for a room
enum room_state {
    EMPTY,
    OCCUPIED
};

// Define the possible events that can occur in a room
enum room_event {
    NOTHING,
    CREAK,
    SCREAM,
    LAUGHTER
};

// Define the structure of a room
struct room {
    enum room_state state;
    enum room_event event;
};

// Define the structure of the haunted house
struct haunted_house {
    struct room rooms[MAX_ROOMS];
};

// Function to initialize the haunted house
void initialize_haunted_house(struct haunted_house *house) {
    // Set all rooms to be empty
    for (int i = 0; i < MAX_ROOMS; i++) {
        house->rooms[i].state = EMPTY;
    }

    // Set a random number of rooms to be occupied
    int num_occupied_rooms = rand() % MAX_ROOMS;
    for (int i = 0; i < num_occupied_rooms; i++) {
        // Choose a random room to be occupied
        int room_index = rand() % MAX_ROOMS;

        // Set the room to be occupied
        house->rooms[room_index].state = OCCUPIED;
    }

    // Set a random number of rooms to have events
    int num_events = rand() % MAX_ROOMS;
    for (int i = 0; i < num_events; i++) {
        // Choose a random room to have an event
        int room_index = rand() % MAX_ROOMS;

        // Choose a random event for the room
        house->rooms[room_index].event = rand() % 4;
    }
}

// Function to simulate the haunted house
void simulate_haunted_house(struct haunted_house *house) {
    // Loop through each room in the house
    for (int i = 0; i < MAX_ROOMS; i++) {
        // Get the room's state and event
        enum room_state state = house->rooms[i].state;
        enum room_event event = house->rooms[i].event;

        // Print the room's description
        printf("You enter room %d.\n", i + 1);
        switch (state) {
            case EMPTY:
                printf("The room is empty.\n");
                break;
            case OCCUPIED:
                printf("The room is occupied.\n");
                break;
        }

        // Print the room's event
        switch (event) {
            case NOTHING:
                printf("Nothing happens.\n");
                break;
            case CREAK:
                printf("You hear a creak.\n");
                break;
            case SCREAM:
                printf("You hear a scream.\n");
                break;
            case LAUGHTER:
                printf("You hear laughter.\n");
                break;
        }

        // Prompt the user to continue
        printf("Press any key to continue.\n");
        getchar();
    }
}

// Main function
int main() {
    // Initialize the random number generator
    srand(time(NULL));

    // Create a haunted house
    struct haunted_house house;

    // Initialize the haunted house
    initialize_haunted_house(&house);

    // Simulate the haunted house
    simulate_haunted_house(&house);

    return 0;
}