//GEMINI-pro DATASET v1.0 Category: TCP/IP Programming ; Style: medieval
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main()
{
    int s, c, n;
    struct sockaddr_in server, client;

    // Create a socket
    s = socket(AF_INET, SOCK_STREAM, 0);
    if (s == -1) {
        perror("socket");
        exit(1);
    }

    // Prepare the server address
    server.sin_family = AF_INET;
    server.sin_port = htons(8080);
    server.sin_addr.s_addr = INADDR_ANY;

    // Bind the socket to the server address
    if (bind(s, (struct sockaddr *)&server, sizeof(server)) == -1) {
        perror("bind");
        exit(1);
    }

    // Listen for incoming connections
    if (listen(s, 5) == -1) {
        perror("listen");
        exit(1);
    }

    // Accept an incoming connection
    c = accept(s, (struct sockaddr *)&client, (socklen_t *)&n);
    if (c == -1) {
        perror("accept");
        exit(1);
    }

    // Send a message to the client
    char *message = "Greetings, fair maiden! I am thy server, ready to serve thy needs.";
    if (send(c, message, strlen(message), 0) == -1) {
        perror("send");
        exit(1);
    }

    // Receive a message from the client
    char buffer[1024];
    if (recv(c, buffer, sizeof(buffer), 0) == -1) {
        perror("recv");
        exit(1);
    }

    // Print the message from the client
    printf("Message from client: %s\n", buffer);

    // Close the connection
    close(c);
    close(s);

    return 0;
}