//GEMINI-pro DATASET v1.0 Category: Online Examination System ; Style: realistic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Structure to represent a question
typedef struct Question {
    char question[100];
    char options[4][50];
    int correct_option;
} Question;

// Structure to represent an exam
typedef struct Exam {
    char name[50];
    int num_questions;
    Question questions[10];
} Exam;

// Function to create a new question
Question create_question(char *question, char options[4][50], int correct_option) {
    Question new_question;
    strcpy(new_question.question, question);
    for (int i = 0; i < 4; i++) {
        strcpy(new_question.options[i], options[i]);
    }
    new_question.correct_option = correct_option;
    return new_question;
}

// Function to create a new exam
Exam create_exam(char *name, int num_questions, Question questions[10]) {
    Exam new_exam;
    strcpy(new_exam.name, name);
    new_exam.num_questions = num_questions;
    for (int i = 0; i < num_questions; i++) {
        new_exam.questions[i] = questions[i];
    }
    return new_exam;
}

// Function to take an exam
void take_exam(Exam exam) {
    int score = 0;
    for (int i = 0; i < exam.num_questions; i++) {
        printf("%s\n", exam.questions[i].question);
        for (int j = 0; j < 4; j++) {
            printf("%d. %s\n", j + 1, exam.questions[i].options[j]);
        }
        int answer;
        printf("Enter your answer: ");
        scanf("%d", &answer);
        if (answer == exam.questions[i].correct_option) {
            score++;
        }
    }
    printf("Your score is %d out of %d\n", score, exam.num_questions);
}

// Main function
int main() {
    // Create a new exam
    Exam exam = create_exam("C Programming Exam", 5, (Question[]) {
        create_question("What is the output of the following code?\nint main() { int x = 10; printf(\"%d\", x++); }", (char[][50]) {"10", "11", "12", "13"}, 1),
        create_question("What is the value of the following expression?\n2 + 3 * 5 - 1", (char[][50]) {"12", "14", "16", "18"}, 0),
        create_question("What is the output of the following code?\nint main() { char *str = \"Hello\"; str++; printf(\"%s\", str); }", (char[][50]) {"Hello", "ello", "llo", "lo"}, 1),
        create_question("What is the time complexity of the following algorithm?\nfor (int i = 0; i < n; i++) { for (int j = 0; j < n; j++) { printf(\"%d\", i * j); } }", (char[][50]) {"O(n)", "O(n^2)", "O(log n)", "O(n log n"}, 1),
        create_question("What is the output of the following code?\nint main() { int x = 10; x &= 3; printf(\"%d\", x); }", (char[][50]) {"0", "1", "2", "3"}, 0)
    });

    // Take the exam
    take_exam(exam);

    return 0;
}