//Code Llama-13B DATASET v1.0 Category: Interprocess communication ; Style: distributed
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <string.h>

// Define shared memory key
#define SHM_KEY (0x1234)

// Define buffer size
#define BUF_SIZE (1024)

// Define process IDs
#define PARENT_ID (0)
#define CHILD_ID (1)

// Define message structure
typedef struct {
    char message[BUF_SIZE];
} message_t;

int main() {
    // Create shared memory
    int shmid = shmget(SHM_KEY, BUF_SIZE, IPC_CREAT | 0666);
    if (shmid == -1) {
        perror("shmget");
        exit(1);
    }

    // Attach shared memory to process
    message_t* message = (message_t*)shmat(shmid, NULL, 0);
    if (message == (void*)-1) {
        perror("shmat");
        exit(1);
    }

    // Create two processes
    pid_t pid = fork();
    if (pid == -1) {
        perror("fork");
        exit(1);
    }

    if (pid == PARENT_ID) {
        // Parent process
        // Wait for child process to write message
        wait(NULL);

        // Read message from shared memory
        printf("Parent process received message: %s\n", message->message);
    } else {
        // Child process
        // Write message to shared memory
        sprintf(message->message, "Hello, I am the child process!");
        printf("Child process wrote message: %s\n", message->message);

        // Detach shared memory
        shmdt(message);

        // Exit child process
        exit(0);
    }

    // Detach shared memory
    shmdt(message);

    // Remove shared memory
    shmctl(shmid, IPC_RMID, NULL);

    return 0;
}