//GEMINI-pro DATASET v1.0 Category: Basic Unix-like Shell ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

// Colors! I love colors!
#define RED "\033[0;31m"
#define GREEN "\033[0;32m"
#define YELLOW "\033[0;33m"
#define BLUE "\033[0;34m"
#define MAGENTA "\033[0;35m"
#define CYAN "\033[0;36m"
#define RESET "\033[0m"

// Some helper functions
void print_error(char *msg) {
  fprintf(stderr, "%sError: %s%s\n", RED, msg, RESET);
}
void print_help() {
  printf("%sUsage: my_shell [flags]%s\n", GREEN, RESET);
  printf("Flags:\n");
  printf("  -h  Show this help message\n");
  printf("  -v  Enable verbose mode\n");
}

// The main function
int main(int argc, char *argv[]) {
  // Parse the flags
  int verbose = 0;
  int c;
  while ((c = getopt(argc, argv, "hv")) != -1) {
    switch (c) {
      case 'h':
        print_help();
        return 0;
      case 'v':
        verbose = 1;
        break;
      default:
        print_error("Invalid flag");
        return 1;
    }
  }

  // The main loop
  while (1) {
    // Print the prompt
    printf("%s%s$ %s", BLUE, getenv("USER"), RESET);

    // Read the command
    char line[1024];
    if (fgets(line, sizeof(line), stdin) == NULL) {
      break;
    }

    // Parse the command
    char *args[10] = {NULL};
    int argc = 0;
    char *token = strtok(line, " ");
    while (token != NULL) {
      args[argc++] = token;
      token = strtok(NULL, " ");
    }

    // Execute the command
    if (argc == 0) {
      // Empty command, do nothing
    } else if (strcmp(args[0], "exit") == 0) {
      // Exit the shell
      break;
    } else if (strcmp(args[0], "help") == 0) {
      // Print the help message
      print_help();
    } else {
      // Run the command
      pid_t pid = fork();
      if (pid == 0) {
        // Child process
        if (execvp(args[0], args) == -1) {
          print_error("Could not execute command");
        }
        exit(1);
      } else if (pid > 0) {
        // Parent process
        int status;
        waitpid(pid, &status, 0);
        if (verbose) {
          printf("Command \"%s\" exited with status %d\n", line, status);
        }
      } else {
        // Fork failed
        print_error("Could not fork");
      }
    }
  }

  return 0;
}