//Gemma-7B DATASET v1.0 Category: Hotel Management System ; Style: statistical
#include <stdio.h>
#include <stdlib.h>

// Define a structure to store hotel room information
struct room
{
    int number;
    char status;
    float rate;
};

// Define a function to calculate the total cost of a room
float calculate_cost(struct room *room, int days)
{
    float total_cost = room->rate * days;
    return total_cost;
}

// Define a function to check if a room is available
int is_room_available(struct room *room)
{
    if (room->status == 'A')
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

// Define a function to book a room
int book_room(struct room *room, int days)
{
    if (is_room_available(room))
    {
        room->status = 'B';
        float total_cost = calculate_cost(room, days);
        printf("Total cost: $%.2f\n", total_cost);
        return 1;
    }
    else
    {
        return 0;
    }
}

int main()
{
    // Create an array of rooms
    struct room rooms[] =
    {
        {1, 'A', 50.0},
        {2, 'A', 60.0},
        {3, 'A', 70.0}
    };

    // Book a room
    book_room(&rooms[0], 3);

    // Check if the room is available
    if (is_room_available(&rooms[0]))
    {
        printf("The room is available.\n");
    }

    return 0;
}