//Gemma-7B DATASET v1.0 Category: Subnet Calculator ; Style: sophisticated
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAX_SUBNETS 256

typedef struct subnet
{
    int mask, host, broadcast, network;
} subnet;

subnet calculateSubnet(int cidr)
{
    subnet subnet;

    switch (cidr)
    {
        case 0:
            subnet.mask = 0;
            subnet.host = 0;
            subnet.broadcast = 0;
            subnet.network = 0;
            break;
        case 1:
            subnet.mask = 255;
            subnet.host = 0;
            subnet.broadcast = 255;
            subnet.network = 0;
            break;
        default:
            subnet.mask = pow(2, 32 - cidr) - 1;
            subnet.host = pow(2, 32 - cidr) - 2;
            subnet.broadcast = pow(2, 32 - cidr) - 1;
            subnet.network = (subnet.mask & ~0xFF) >> 8;
            break;
    }

    return subnet;
}

int main()
{
    subnet subnet = calculateSubnet(24);

    printf("Subnet Mask: %x\n", subnet.mask);
    printf("Number of Hosts: %d\n", subnet.host);
    printf("Broadcast Address: %x\n", subnet.broadcast);
    printf("Network Address: %x\n", subnet.network);

    return 0;
}