//Falcon-180B DATASET v1.0 Category: Bitwise operations ; Style: active
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <time.h>
#include <limits.h>
#include <float.h>
#include <locale.h>
#include <wchar.h>
#include <wctype.h>
#include <stdbool.h>

#define MAX_SIZE 1000

void setBit(int *num, int pos) {
    *num = *num | (1 << pos);
}

void clearBit(int *num, int pos) {
    *num = *num & ~(1 << pos);
}

void toggleBit(int *num, int pos) {
    *num = *num ^ (1 << pos);
}

int getBit(int num, int pos) {
    return (num & (1 << pos))!= 0;
}

int countBits(int num) {
    int count = 0;
    while (num!= 0) {
        count++;
        num = num >> 1;
    }
    return count;
}

int main() {
    int num1 = 0b10101010;
    int num2 = 0b11100000;

    printf("Num1 = %d\n", num1);
    printf("Num2 = %d\n", num2);

    setBit(&num1, 3);
    clearBit(&num1, 5);
    toggleBit(&num1, 4);

    printf("Num1 after bit manipulation = %d\n", num1);

    int result = num1 & num2;
    printf("Result of bitwise AND operation = %d\n", result);

    result = num1 | num2;
    printf("Result of bitwise OR operation = %d\n", result);

    result = num1 ^ num2;
    printf("Result of bitwise XOR operation = %d\n", result);

    result = num1 << 2;
    printf("Result of left shift operation = %d\n", result);

    result = num1 >> 2;
    printf("Result of right shift operation = %d\n", result);

    printf("Number of set bits in num1 = %d\n", countBits(num1));

    return 0;
}