//Falcon-180B DATASET v1.0 Category: Text-Based Adventure Game ; Style: protected
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Function prototypes
void start_game(void);
void game_loop(void);
void end_game(int player_score);

int main(void) {
    srand(time(NULL)); // Seed the random number generator
    start_game(); // Start the game
    return 0;
}

void start_game(void) {
    printf("Welcome to the Text-Based Adventure Game!\n");
    printf("You find yourself in a mysterious forest. What will you do?\n");
}

void game_loop(void) {
    char choice;
    int player_score = 0;

    while (1) {
        printf("\n");
        printf("You are in the forest. You can:\n");
        printf("1. Go north\n");
        printf("2. Go south\n");
        printf("3. Go east\n");
        printf("4. Go west\n");
        printf("5. Quit\n");
        printf("\n");
        printf("Enter your choice: ");
        scanf("%c", &choice);

        switch (choice) {
        case '1':
            printf("You go north and find a treasure chest!\n");
            player_score += 10;
            break;
        case '2':
            printf("You go south and find a magical fountain.\n");
            player_score += 5;
            break;
        case '3':
            printf("You go east and find a wise old wizard.\n");
            player_score += 15;
            break;
        case '4':
            printf("You go west and find a hidden cave.\n");
            player_score += 20;
            break;
        case '5':
            end_game(player_score);
            break;
        default:
            printf("Invalid choice. Try again.\n");
        }
    }
}

void end_game(int player_score) {
    printf("\n");
    printf("Game over! You scored %d points.\n", player_score);
}