//Falcon-180B DATASET v1.0 Category: Threading Library Implementation ; Style: Cyberpunk
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

#define NUM_THREADS 4

// Mutex for critical section
pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;

// Condition variable for thread synchronization
pthread_cond_t cond = PTHREAD_COND_INITIALIZER;

// Array of thread IDs
pthread_t threads[NUM_THREADS];

// Function to be executed by each thread
void* cyberpunk_thread(void* arg) {
    int id = *((int*) arg);
    printf("Thread %d starting...\n", id);

    // Lock mutex before entering critical section
    pthread_mutex_lock(&mutex);
    printf("Thread %d entered critical section.\n", id);

    // Wait for turn using condition variable
    pthread_cond_wait(&cond, &mutex);

    printf("Thread %d leaving critical section.\n", id);

    // Unlock mutex after leaving critical section
    pthread_mutex_unlock(&mutex);

    return NULL;
}

int main() {
    int i;
    int ids[NUM_THREADS] = {1, 2, 3, 4};

    // Create threads
    for (i = 0; i < NUM_THREADS; i++) {
        pthread_create(&threads[i], NULL, cyberpunk_thread, &ids[i]);
    }

    // Join threads
    for (i = 0; i < NUM_THREADS; i++) {
        pthread_join(threads[i], NULL);
    }

    return 0;
}