//MISTRAL-7B DATASET v1.0 Category: Haunted House Simulator ; Style: Cryptic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define SHADOWS 10
#define GUESTS 5
#define HAUNTED_DOORS 3

typedef struct {
    int eyes;
    int mouth;
} Ghost;

void hauntedDoor(int door) {
    if (door > 0 && door <= HAUNTED_DOORS) {
        srand(time(NULL));
        int creak = rand() % 10 + 1;
        if (creak % 2 == 0) {
            printf("\nDoor %d creaks ominously...\n", door);
        }
    }
}

void apparition(void) {
    Ghost ghast;
    ghast.eyes = rand() % 5 + 1;
    ghast.mouth = rand() % 5 + 1;
    printf("\nAn apparition appears with %d eyes and %d mouths!\n", ghast.eyes, ghast.mouth);
}

void shadowMover(int numShadows) {
    int i;
    for (i = 0; i < numShadows; i++) {
        hauntedDoor(i + 1);
        printf("\nShadow %d moves...\n", i + 1);
        sleep(1);
    }
}

void simulateGuest(int numGuests) {
    int i;
    for (i = 1; i <= numGuests; i++) {
        printf("\nGuest %d enters the haunted house...\n", i);
        apparition();
        shadowMover(SHADOWS);
        printf("\nGuest %d exits the haunted house, shaken but alive...\n", i);
    }
}

int main() {
    printf("\nWelcome to the Haunted House Simulator...\n");
    simulateGuest(GUESTS);
    return 0;
}