//Falcon-180B DATASET v1.0 Category: Elevator Simulation ; Style: optimized
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_FLOORS 10
#define NUM_ELEVATORS 2
#define MAX_REQUESTS 100

typedef struct {
    int floor;
    int direction;
} Elevator;

Elevator elevators[NUM_ELEVATORS];
int elevator_count = 0;
int floor_requests[NUM_FLOORS];
int num_requests = 0;
int current_time = 0;
int simulation_time = 3600; // 1 hour

void initialize_elevators() {
    for (int i = 0; i < NUM_ELEVATORS; i++) {
        elevators[i].floor = rand() % NUM_FLOORS;
        elevators[i].direction = rand() % 2 == 0? 1 : -1;
    }
}

void add_floor_request(int floor) {
    if (num_requests >= MAX_REQUESTS) {
        printf("Sorry, too many requests.\n");
        return;
    }

    if (floor < 0 || floor >= NUM_FLOORS) {
        printf("Invalid floor.\n");
        return;
    }

    floor_requests[num_requests++] = floor;
}

void process_requests() {
    while (current_time < simulation_time && num_requests > 0) {
        int min_distance = 1000000;
        int closest_elevator = -1;

        for (int i = 0; i < NUM_ELEVATORS; i++) {
            int elevator_distance = abs(elevators[i].floor - floor_requests[0]);

            if (elevator_distance < min_distance) {
                min_distance = elevator_distance;
                closest_elevator = i;
            }
        }

        if (closest_elevator == -1) {
            printf("No elevator available.\n");
        } else {
            elevators[closest_elevator].floor = floor_requests[0];
            elevators[closest_elevator].direction = (elevators[closest_elevator].floor < floor_requests[0])? -1 : 1;
            floor_requests[0] = -1;
            num_requests--;
        }

        current_time++;
    }
}

void move_elevators() {
    for (int i = 0; i < NUM_ELEVATORS; i++) {
        elevators[i].floor += elevators[i].direction;

        if (elevators[i].floor < 0) {
            elevators[i].floor = NUM_FLOORS - 1;
        } else if (elevators[i].floor >= NUM_FLOORS) {
            elevators[i].floor = 0;
        }
    }
}

int main() {
    srand(time(NULL));
    initialize_elevators();

    while (num_requests > 0) {
        add_floor_request(rand() % NUM_FLOORS);
    }

    process_requests();

    return 0;
}