//GEMINI-pro DATASET v1.0 Category: Robot movement control ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define ROBOT_X_SIZE 10
#define ROBOT_Y_SIZE 10

typedef struct {
    int x;
    int y;
} point;

typedef struct {
    point current_position;
    point target_position;
    int orientation;
} robot;

void print_robot(robot* r) {
    for (int i = 0; i < ROBOT_X_SIZE; i++) {
        for (int j = 0; j < ROBOT_Y_SIZE; j++) {
            if (r->current_position.x == i && r->current_position.y == j) {
                printf("@");
            } else {
                printf(" ");
            }
        }
        printf("\n");
    }
}

void move_robot(robot* r) {
    int dx = r->target_position.x - r->current_position.x;
    int dy = r->target_position.y - r->current_position.y;

    if (dx > 0) {
        r->current_position.x++;
    } else if (dx < 0) {
        r->current_position.x--;
    }

    if (dy > 0) {
        r->current_position.y++;
    } else if (dy < 0) {
        r->current_position.y--;
    }
}

int main() {
    robot r;
    r.current_position.x = 0;
    r.current_position.y = 0;
    r.target_position.x = 9;
    r.target_position.y = 9;
    r.orientation = 0;

    while (r.current_position.x != r.target_position.x || r.current_position.y != r.target_position.y) {
        move_robot(&r);
        print_robot(&r);
        printf("\n");
    }

    return 0;
}