//Falcon-180B DATASET v1.0 Category: Temperature monitor ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SENSORS 10
#define MAX_SENSOR_NAME_LENGTH 32
#define MAX_TEMP_VALUE_LENGTH 16

typedef struct {
    char name[MAX_SENSOR_NAME_LENGTH];
    double temp;
} sensor_t;

int sensor_count = 0;
sensor_t sensors[MAX_SENSORS];

void add_sensor(char* name) {
    if (sensor_count >= MAX_SENSORS) {
        printf("Error: Maximum number of sensors reached.\n");
        return;
    }

    strcpy(sensors[sensor_count].name, name);
    sensors[sensor_count].temp = 0;
    sensor_count++;
}

void update_sensor_temp(int index, double temp) {
    if (index < 0 || index >= sensor_count) {
        printf("Error: Invalid sensor index.\n");
        return;
    }

    sensors[index].temp = temp;
}

void print_sensor_temps() {
    printf("Sensor Name\tTemperature\n");
    for (int i = 0; i < sensor_count; i++) {
        printf("%s\t%.2f\n", sensors[i].name, sensors[i].temp);
    }
}

int main() {
    add_sensor("CPU");
    add_sensor("GPU");
    add_sensor("Motherboard");

    update_sensor_temp(0, 50.5);
    update_sensor_temp(1, 60.7);
    update_sensor_temp(2, 35.2);

    print_sensor_temps();

    return 0;
}