//GPT-4o-mini DATASET v1.0 Category: Greedy Algorithms ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>

// Define a structure to represent an activity
struct Activity {
    int start;
    int finish;
};

// Comparison function to sort activities based on finish times
int compare(const void *a, const void *b) {
    return ((struct Activity *)a)->finish - ((struct Activity *)b)->finish;
}

// Function to select maximum number of activities that don't overlap
void selectActivities(struct Activity activities[], int n) {
    // Sort activities based on their finish times
    qsort(activities, n, sizeof(struct Activity), compare);

    printf("Selected activities are:\n");

    // The first activity always gets selected
    int lastSelectedIndex = 0;
    printf("Activity [%d]: Start = %d, Finish = %d\n", lastSelectedIndex, activities[lastSelectedIndex].start, activities[lastSelectedIndex].finish);

    // Iterate through the remaining activities
    for (int i = 1; i < n; i++) {
        // If this activity starts after or when the last selected activity finishes
        if (activities[i].start >= activities[lastSelectedIndex].finish) {
            printf("Activity [%d]: Start = %d, Finish = %d\n", i, activities[i].start, activities[i].finish);
            lastSelectedIndex = i; // Update the last selected activity
        }
    }
}

// Main function to run the activity selection algorithm
int main() {
    // Example array of activities represented by their start and finish times
    struct Activity activities[] = {
        {0, 6}, {5, 7}, {3, 4}, {2, 8},
        {5, 9}, {6, 10}, {8, 9}, {12, 14},
        {9, 12}, {11, 15}
    };

    int n = sizeof(activities) / sizeof(activities[0]); // Number of activities

    selectActivities(activities, n); // Call the function to select activities

    return 0;
}