//Falcon-180B DATASET v1.0 Category: Packet Capturer with pcap library ; Style: peaceful
#include <pcap.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#define MAX_PKT_SIZE 65535

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    printf("Packet received: %d bytes\n", header->caplen);
}

int main(int argc, char *argv[]) {
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;
    struct bpf_program filter;
    char filter_str[] = "tcp and host 192.168.1.1";
    int net = 1, mask = 0xffffff00;
    int ret = 0;

    // Open the network device
    handle = pcap_open_live(argv[1], MAX_PKT_SIZE, 0, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Error opening network device: %s\n", errbuf);
        exit(1);
    }

    // Compile the filter expression
    ret = pcap_compile(handle, &filter, filter_str, 0, net);
    if (ret == -1) {
        fprintf(stderr, "Error compiling filter expression: %s\n", pcap_geterr(handle));
        exit(1);
    }

    // Set the filter on the network device
    ret = pcap_setfilter(handle, &filter);
    if (ret == -1) {
        fprintf(stderr, "Error setting filter: %s\n", pcap_geterr(handle));
        exit(1);
    }

    // Start capturing packets
    ret = pcap_loop(handle, -1, packet_handler, NULL);
    if (ret == -1) {
        fprintf(stderr, "Error capturing packets: %s\n", pcap_geterr(handle));
        exit(1);
    }

    return 0;
}