//Falcon-180B DATASET v1.0 Category: Banking Record System ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ACCOUNTS 100
#define MAX_TRANSACTIONS 1000

typedef struct {
    int account_number;
    char name[50];
    float balance;
} account;

typedef struct {
    int account_number_from;
    int account_number_to;
    float amount;
    char description[100];
} transaction;

account accounts[MAX_ACCOUNTS];
transaction transactions[MAX_TRANSACTIONS];
int account_count = 0;
int transaction_count = 0;

void add_account(int account_number, char* name, float balance) {
    accounts[account_count].account_number = account_number;
    strcpy(accounts[account_count].name, name);
    accounts[account_count].balance = balance;
    account_count++;
}

void add_transaction(int account_number_from, int account_number_to, float amount, char* description) {
    transactions[transaction_count].account_number_from = account_number_from;
    transactions[transaction_count].account_number_to = account_number_to;
    transactions[transaction_count].amount = amount;
    strcpy(transactions[transaction_count].description, description);
    transaction_count++;
}

void print_accounts() {
    printf("Accounts:\n");
    for(int i=0; i<account_count; i++) {
        printf("%d - %s - $%.2f\n", accounts[i].account_number, accounts[i].name, accounts[i].balance);
    }
}

void print_transactions() {
    printf("\nTransactions:\n");
    for(int i=0; i<transaction_count; i++) {
        printf("%d -> %d - $%.2f - %s\n", transactions[i].account_number_from, transactions[i].account_number_to, transactions[i].amount, transactions[i].description);
    }
}

int main() {
    add_account(12345, "John Doe", 1000.00);
    add_account(23456, "Jane Doe", 5000.00);
    add_transaction(12345, 23456, 200.00, "Transfer");
    add_transaction(23456, 12345, 300.00, "Transfer");

    print_accounts();
    print_transactions();

    return 0;
}