//Falcon-180B DATASET v1.0 Category: Electronic Voting System ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_CANDIDATES 5
#define MAX_VOTERS 100
#define MAX_VOTES 10

typedef struct {
    char name[50];
    int votes;
} Candidate;

typedef struct {
    char name[50];
    int vote;
} Voter;

Candidate candidates[MAX_CANDIDATES];
Voter voters[MAX_VOTERS];
int num_candidates = 0;
int num_voters = 0;

void add_candidate(char* name) {
    strcpy(candidates[num_candidates].name, name);
    candidates[num_candidates].votes = 0;
    num_candidates++;
}

void add_voter(char* name) {
    strcpy(voters[num_voters].name, name);
    num_voters++;
}

void vote(int candidate_index, int voter_index) {
    candidates[candidate_index].votes++;
    voters[voter_index].vote = candidate_index;
}

void print_results() {
    int max_votes = 0;
    for (int i = 0; i < num_candidates; i++) {
        if (candidates[i].votes > max_votes) {
            max_votes = candidates[i].votes;
        }
    }

    printf("Election Results:\n");
    for (int i = 0; i < num_candidates; i++) {
        printf("%s: %d votes (%d%%)\n", candidates[i].name, candidates[i].votes, (int)((double)candidates[i].votes / max_votes * 100));
    }
}

int main() {
    add_candidate("Candidate 1");
    add_candidate("Candidate 2");
    add_candidate("Candidate 3");
    add_candidate("Candidate 4");
    add_candidate("Candidate 5");

    add_voter("Voter 1");
    add_voter("Voter 2");
    add_voter("Voter 3");
    add_voter("Voter 4");
    add_voter("Voter 5");

    vote(0, 0);
    vote(1, 1);
    vote(2, 2);
    vote(3, 3);
    vote(4, 4);

    print_results();

    return 0;
}