//GPT-4o-mini DATASET v1.0 Category: Weather simulation ; Style: multivariable
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_CITIES 5
#define DAYS_IN_FORECAST 7

typedef struct {
    char name[30];
    float temperature[DAYS_IN_FORECAST];   // Temperatures for different days
    int humidity[DAYS_IN_FORECAST];         // Humidity percentages
    float windSpeed[DAYS_IN_FORECAST];      // Wind speed in km/h
} CityWeather;

void generateWeatherData(CityWeather* city) {
    for(int i = 0; i < DAYS_IN_FORECAST; i++) {
        city->temperature[i] = (rand() % 351) / 10.0; // Random temp between 0.0 and 35.0
        city->humidity[i] = rand() % 101;             // Random humidity between 0% and 100%
        city->windSpeed[i] = (rand() % 151) / 10.0;   // Random wind speed between 0.0 and 15.0
    }
}

void printWeatherForecast(CityWeather* cities, int cityCount) {
    printf("Weather Forecast for the Next %d Days:\n\n", DAYS_IN_FORECAST);
    for(int i = 0; i < cityCount; i++) {
        printf("City: %s\n", cities[i].name);
        printf("Day\tTemperature (°C)\tHumidity (%%)\tWind Speed (km/h)\n");
        for(int j = 0; j < DAYS_IN_FORECAST; j++) {
            printf("%d\t%.1f\t\t\t%d\t\t%.1f\n", j + 1, 
                   cities[i].temperature[j], 
                   cities[i].humidity[j], 
                   cities[i].windSpeed[j]);
        }
        printf("\n");
    }
}

int main() {
    srand(time(0)); // Seed randomness

    CityWeather cities[MAX_CITIES] = {
        {"New York"},
        {"Los Angeles"},
        {"Chicago"},
        {"Houston"},
        {"Phoenix"}
    };

    // Generating weather data for each city
    for(int i = 0; i < MAX_CITIES; i++) {
        generateWeatherData(&cities[i]);
    }

    printWeatherForecast(cities, MAX_CITIES);

    return 0;
}