//GEMINI-pro DATASET v1.0 Category: Graph Coloring Problem ; Style: artistic
#include <stdio.h>
#include <stdlib.h>

// Number of vertices in the graph
#define V 4

// A utility function to check if the current color assignment
// is safe for vertex v
int isSafe(int graph[V][V], int v, int color, int c[])
{
	for (int i = 0; i < V; i++)
		if (graph[v][i] && c[i] == color)
			return 0;
	return 1;
}

// A recursive utility function to solve m coloring problem
int graphColoringUtil(int graph[V][V], int m, int c[], int v)
{
	// If all vertices are assigned a color then return true
	if (v == V)
		return 1;

	// Consider this vertex v and try different colors
	for (int i = 1; i <= m; i++) {
		// Check if assignment of color i to vertex v is safe
		if (isSafe(graph, v, i, c)) {
			c[v] = i;

			// Recursively assign colors to the remaining vertices
			if (graphColoringUtil(graph, m, c, v + 1))
				return 1;

			// If assigning color i to vertex v didn't lead to a
			// solution, then remove it
			c[v] = 0;
		}
	}

	// If no color can be assigned to this vertex then return false
	return 0;
}

// The function to solve the graph coloring problem
int graphColoring(int graph[V][V], int m)
{
	// Create an array to store colors assigned to all vertices.
	// Initialize all colors as 0
	int c[V];
	for (int i = 0; i < V; i++)
		c[i] = 0;

	// Call the recursive function to assign colors
	if (graphColoringUtil(graph, m, c, 0) == 0) {
		printf("Solution does not exist");
		return 0;
	}

	// Print the solution
	printf("Following are the assigned colors:\n");
	for (int i = 0; i < V; i++)
		printf("Vertex %d ---> Color %d\n", i, c[i]);

	return 1;
}

// Driver program to test graph coloring
int main()
{
	/* Create following graph
	   (0)--(1)--(2)
	   | /  \  |
	   (3)--(4)--(5)
	*/
	int graph[V][V] = {
		{ 0, 1, 1, 1, 0, 0 },
		{ 1, 0, 1, 0, 1, 1 },
		{ 1, 1, 0, 1, 0, 1 },
		{ 1, 0, 1, 0, 1, 0 },
		{ 0, 1, 0, 1, 0, 1 },
		{ 0, 1, 1, 0, 1, 0 },
	};
	int m = 3; // Number of colors

	graphColoring(graph, m);

	return 0;
}