//GEMINI-pro DATASET v1.0 Category: TCP/IP Programming ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8080

int main() {
    // Create a server socket
    int server_socket = socket(AF_INET, SOCK_STREAM, 0);
    if (server_socket == -1) {
        perror("socket");
        return EXIT_FAILURE;
    }

    // Set the server socket to be reusable
    int reuseaddr = 1;
    if (setsockopt(server_socket, SOL_SOCKET, SO_REUSEADDR, &reuseaddr, sizeof(reuseaddr)) == -1) {
        perror("setsockopt");
        return EXIT_FAILURE;
    }

    // Bind the server socket to the port
    struct sockaddr_in server_address;
    server_address.sin_family = AF_INET;
    server_address.sin_addr.s_addr = INADDR_ANY;
    server_address.sin_port = htons(PORT);
    if (bind(server_socket, (struct sockaddr *)&server_address, sizeof(server_address)) == -1) {
        perror("bind");
        return EXIT_FAILURE;
    }

    // Listen for incoming connections
    if (listen(server_socket, 10) == -1) {
        perror("listen");
        return EXIT_FAILURE;
    }

    // Accept an incoming connection
    int client_socket = accept(server_socket, NULL, NULL);
    if (client_socket == -1) {
        perror("accept");
        return EXIT_FAILURE;
    }

    // Read the data from the client
    char buffer[1024];
    size_t bytes_read = read(client_socket, buffer, sizeof(buffer));
    if (bytes_read == -1) {
        perror("read");
        return EXIT_FAILURE;
    }

    // Print the data from the client
    printf("Received from client: %s", buffer);

    // Write the data back to the client
    if (write(client_socket, buffer, bytes_read) == -1) {
        perror("write");
        return EXIT_FAILURE;
    }

    // Close the client socket
    close(client_socket);

    // Close the server socket
    close(server_socket);

    return EXIT_SUCCESS;
}