//Falcon-180B DATASET v1.0 Category: Socket programming ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#define BUFFER_SIZE 1024

int main() {
    int sockfd, newsockfd, portno;
    struct sockaddr_in serv_addr, cli_addr;
    char buffer[BUFFER_SIZE];
    int addrlen, n;

    printf("CHEERFUL SOCKET PROGRAM STARTED\n");

    // Create socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        printf("Error: Socket creation failed\n");
        exit(1);
    }

    printf("CHEERFUL SOCKET CREATED\n");

    // Set server address
    portno = 8080;
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    serv_addr.sin_port = htons(portno);

    // Bind server address to socket
    if (bind(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
        printf("Error: Bind failed\n");
        exit(1);
    }

    printf("CHEERFUL SOCKET BOUND\n");

    // Listen to incoming connections
    if (listen(sockfd, 3) < 0) {
        printf("Error: Listen failed\n");
        exit(1);
    }

    printf("CHEERFUL SOCKET LISTENING\n");

    // Accept incoming connections
    addrlen = sizeof(cli_addr);
    newsockfd = accept(sockfd, (struct sockaddr *)&cli_addr, &addrlen);
    if (newsockfd < 0) {
        printf("Error: Accept failed\n");
        exit(1);
    }

    printf("CHEERFUL CONNECTION ACCEPTED\n");

    // Receive data from client
    n = recv(newsockfd, buffer, BUFFER_SIZE, 0);
    if (n < 0) {
        printf("Error: Receive failed\n");
        exit(1);
    }

    printf("CHEERFUL DATA RECEIVED: %s\n", buffer);

    // Send data to client
    strcpy(buffer, "CHEERFUL RESPONSE");
    send(newsockfd, buffer, strlen(buffer), 0);

    printf("CHEERFUL DATA SENT\n");

    // Close sockets
    close(sockfd);
    close(newsockfd);

    printf("CHEERFUL SOCKET PROGRAM ENDED\n");

    return 0;
}