//Falcon-180B DATASET v1.0 Category: Mailing list manager ; Style: happy
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SUBSCRIBERS 100
#define MAX_EMAIL_LENGTH 100
#define MAX_NAME_LENGTH 50

// Subscriber data structure
typedef struct {
    char name[MAX_NAME_LENGTH];
    char email[MAX_EMAIL_LENGTH];
} Subscriber;

// Function to add a new subscriber
void addSubscriber(Subscriber subscribers[], int numSubscribers, char* name, char* email) {
    if (numSubscribers >= MAX_SUBSCRIBERS) {
        printf("Sorry, the mailing list is full!\n");
        return;
    }

    strcpy(subscribers[numSubscribers].name, name);
    strcpy(subscribers[numSubscribers].email, email);
    numSubscribers++;
}

// Function to remove a subscriber by email
void removeSubscriber(Subscriber subscribers[], int numSubscribers, char* email) {
    int i;
    for (i = 0; i < numSubscribers; i++) {
        if (strcmp(subscribers[i].email, email) == 0) {
            memmove(&subscribers[i], &subscribers[i+1], (numSubscribers - i - 1) * sizeof(Subscriber));
            numSubscribers--;
            break;
        }
    }
}

// Function to send an email to all subscribers
void sendEmail(Subscriber subscribers[], int numSubscribers, char* subject, char* message) {
    int i;
    for (i = 0; i < numSubscribers; i++) {
        printf("Sending email to %s (%s)\n", subscribers[i].name, subscribers[i].email);
    }
}

// Main function
int main() {
    Subscriber subscribers[MAX_SUBSCRIBERS];
    int numSubscribers = 0;

    // Add some subscribers
    addSubscriber(subscribers, numSubscribers, "Alice", "alice@example.com");
    addSubscriber(subscribers, numSubscribers, "Bob", "bob@example.com");
    addSubscriber(subscribers, numSubscribers, "Charlie", "charlie@example.com");

    // Remove a subscriber
    removeSubscriber(subscribers, numSubscribers, "alice@example.com");

    // Send an email to all subscribers
    sendEmail(subscribers, numSubscribers, "Hello!", "This is a test email.");

    return 0;
}