//GPT-4o-mini DATASET v1.0 Category: Recursive ; Style: mathematical
#include <stdio.h>

// Function to calculate the factorial of a number
unsigned long long factorial(int n) {
    if (n == 0) {
        return 1; // base case
    } else {
        return n * factorial(n - 1); // recursive case
    }
}

// Function to calculate the nth Fibonacci number
int fibonacci(int n) {
    if (n == 0) {
        return 0; // base case
    } else if (n == 1) {
        return 1; // base case
    } else {
        return fibonacci(n - 1) + fibonacci(n - 2); // recursive case
    }
}

// Function to calculate the greatest common divisor (GCD) using recursion
int gcd(int a, int b) {
    if (b == 0) {
        return a; // base case
    } else {
        return gcd(b, a % b); // recursive case
    }
}

// Function to calculate the value of n raised to the power of p
double power(double n, int p) {
    if (p == 0) {
        return 1.0; // base case
    } else if (p < 0) {
        return 1.0 / power(n, -p); // handling negative exponent
    } else {
        return n * power(n, p - 1); // recursive case
    }
}

// Function to calculate the sum of natural numbers up to n
int sum_natural(int n) {
    if (n <= 0) {
        return 0; // base case
    } else {
        return n + sum_natural(n - 1); // recursive case
    }
}

// Function to reverse a string recursively
void reverse_string(char* str, int start, int end) {
    if (start >= end) {
        return; // base case
    } else {
        // Swap characters
        char temp = str[start];
        str[start] = str[end];
        str[end] = temp;

        // Recursive call
        reverse_string(str, start + 1, end - 1);
    }
}

// Function to calculate the nth triangular number
int triangular_number(int n) {
    if (n == 0) {
        return 0; // base case
    } else {
        return n + triangular_number(n - 1); // recursive case
    }
}

// Function to compute the sum of an array recursively
int sum_array(int arr[], int size) {
    if (size == 0) {
        return 0; // base case
    } else {
        return arr[size - 1] + sum_array(arr, size - 1); // recursive case
    }
}

int main() {
    // Example 1: Factorial
    int num_factorial = 5;
    printf("Factorial of %d = %llu\n", num_factorial, factorial(num_factorial));

    // Example 2: Fibonacci
    int num_fib = 6;
    printf("Fibonacci number at position %d = %d\n", num_fib, fibonacci(num_fib));

    // Example 3: GCD
    int a = 24, b = 36;
    printf("GCD of %d and %d = %d\n", a, b, gcd(a, b));

    // Example 4: Power
    double base = 3.0;
    int exponent = 4;
    printf("%.2f raised to the power of %d = %.2f\n", base, exponent, power(base, exponent));

    // Example 5: Sum of natural numbers
    int n_sum = 10;
    printf("Sum of natural numbers up to %d = %d\n", n_sum, sum_natural(n_sum));

    // Example 6: Reverse a string
    char str[] = "Hello World";
    reverse_string(str, 0, sizeof(str) - 2); // excluding null terminator
    printf("Reversed string = %s\n", str);

    // Example 7: Triangular number
    int num_triangular = 5;
    printf("The %dth triangular number = %d\n", num_triangular, triangular_number(num_triangular));

    // Example 8: Sum of an array
    int arr[] = {1, 2, 3, 4, 5};
    int arr_size = sizeof(arr) / sizeof(arr[0]);
    printf("Sum of array elements = %d\n", sum_array(arr, arr_size));

    return 0;
}