//GPT-4o-mini DATASET v1.0 Category: Packet Capturer with pcap library ; Style: curious
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <arpa/inet.h>
#include <netinet/ip.h>
#include <netinet/ether.h>
#include <unistd.h>
#include <string.h>

// Function to print packet information
void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    printf("Packet Captured with length of [%d] bytes\n", header->len);

    // Extract the Ethernet header
    struct ether_header *eth_header = (struct ether_header *) packet;
    
    // Source and Destination MAC addresses
    printf("Source MAC: %s\n", ether_ntoa((struct ether_addr *)&eth_header->ether_shost));
    printf("Destination MAC: %s\n", ether_ntoa((struct ether_addr *)&eth_header->ether_dhost));
    
    // Check for IP protocol
    if (ntohs(eth_header->ether_type) == ETHERTYPE_IP) {
        const struct ip *ip_header = (struct ip *)(packet + sizeof(struct ether_header));
        char src_ip[INET_ADDRSTRLEN];
        char dst_ip[INET_ADDRSTRLEN];
        inet_ntop(AF_INET, &ip_header->ip_src, src_ip, sizeof(src_ip));
        inet_ntop(AF_INET, &ip_header->ip_dst, dst_ip, sizeof(dst_ip));

        printf("IP Protocol: %d\n", ip_header->ip_p);
        printf("Source IP: %s\n", src_ip);
        printf("Destination IP: %s\n", dst_ip);
    }

    printf("------------------------------------------------------\n");
}

int main(int argc, char *argv[]) {
    char *device;               // Network device to capture packets
    char errbuf[PCAP_ERRBUF_SIZE]; // Buffer for error messages
    pcap_t *handle;            // Session handle

    // Curious introduction
    printf("Welcome to the Curious Packet Capturer!\n");
    printf("Sniffing the secrets of the network...\n");

    // Find the first suitable device
    device = pcap_lookupdev(errbuf);
    if (device == NULL) {
        fprintf(stderr, "Could not locate device: %s\n", errbuf);
        return EXIT_FAILURE;
    }
    printf("Capturing on device: %s\n", device);

    // Open the device for packet capture
    handle = pcap_open_live(device, BUFSIZ, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Could not open device %s: %s\n", device, errbuf);
        return EXIT_FAILURE;
    }

    // Apply a filter (optional, but a curious delight)
    struct bpf_program fp;
    char filter_exp[] = "ip"; // Filter for IP packets
    if (pcap_compile(handle, &fp, filter_exp, 0, PCAP_NETMASK_UNKNOWN) == -1) {
        fprintf(stderr, "Could not compile filter: %s\n", pcap_geterr(handle));
        return EXIT_FAILURE;
    }
    if (pcap_setfilter(handle, &fp) == -1) {
        fprintf(stderr, "Could not set filter: %s\n", pcap_geterr(handle));
        return EXIT_FAILURE;
    }

    // Capturing packets: the grand finale!
    printf("Starting packet capture, press Ctrl+C to stop...\n");
    pcap_loop(handle, 0, packet_handler, NULL);

    // Cleanup
    pcap_freecode(&fp);
    pcap_close(handle);
    printf("Packet capture ended. Farewell!\n");

    return EXIT_SUCCESS;
}