//Gemma-7B DATASET v1.0 Category: Pac-Man Game Clone ; Style: Sherlock Holmes
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAP_SIZE 20
#define PACMAN_SIZE 5
#define FOOD_SIZE 5

typedef struct Pacman {
    int x, y;
    char direction;
} Pacman;

typedef struct Food {
    int x, y;
} Food;

Pacman pacman;
Food food;

void initialize() {
    pacman.x = MAP_SIZE / 2;
    pacman.y = MAP_SIZE / 2;
    pacman.direction = 'r';

    food.x = rand() % MAP_SIZE;
    food.y = rand() % MAP_SIZE;
}

void movePacman() {
    switch (pacman.direction) {
        case 'r':
            pacman.x++;
            break;
        case 'l':
            pacman.x--;
            break;
        case 'u':
            pacman.y--;
            break;
        case 'd':
            pacman.y++;
            break;
    }
}

void drawMap() {
    for (int y = 0; y < MAP_SIZE; y++) {
        for (int x = 0; x < MAP_SIZE; x++) {
            if (x == pacman.x && y == pacman.y) {
                printf("P");
            } else if (x == food.x && y == food.y) {
                printf("F");
            } else {
                printf(".");
            }
        }
        printf("\n");
    }
}

int main() {
    initialize();

    while (1) {
        movePacman();
        drawMap();

        if (pacman.x == food.x && pacman.y == food.y) {
            printf("You win!");
            break;
        }

        if (pacman.x < 0 || pacman.x >= MAP_SIZE || pacman.y < 0 || pacman.y >= MAP_SIZE) {
            printf("Game over!");
            break;
        }

        sleep(0.1);
    }

    return 0;
}