//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

#define MAX_NODES 50
#define MAX_EDGES 100

typedef struct {
    int id;
    char name[20];
} Node;

typedef struct {
    int source;
    int destination;
    int weight;
} Edge;

void add_edge(Edge edges[], int num_edges, int source, int destination, int weight) {
    if (num_edges >= MAX_EDGES) {
        printf("Error: Maximum number of edges reached.\n");
        exit(1);
    }
    edges[num_edges].source = source;
    edges[num_edges].destination = destination;
    edges[num_edges].weight = weight;
    num_edges++;
}

void add_node(Node nodes[], int num_nodes, int id, char name[]) {
    if (num_nodes >= MAX_NODES) {
        printf("Error: Maximum number of nodes reached.\n");
        exit(1);
    }
    nodes[num_nodes].id = id;
    strcpy(nodes[num_nodes].name, name);
    num_nodes++;
}

void print_edges(Edge edges[], int num_edges) {
    printf("Edges:\n");
    for (int i = 0; i < num_edges; i++) {
        printf("%d -> %d (%d)\n", edges[i].source, edges[i].destination, edges[i].weight);
    }
}

void print_nodes(Node nodes[], int num_nodes) {
    printf("Nodes:\n");
    for (int i = 0; i < num_nodes; i++) {
        printf("%d: %s\n", nodes[i].id, nodes[i].name);
    }
}

int main() {
    Node nodes[MAX_NODES];
    Edge edges[MAX_EDGES];
    int num_nodes = 0;
    int num_edges = 0;

    add_node(nodes, num_nodes, 1, "Node 1");
    add_node(nodes, num_nodes, 2, "Node 2");
    add_node(nodes, num_nodes, 3, "Node 3");
    add_node(nodes, num_nodes, 4, "Node 4");
    add_node(nodes, num_nodes, 5, "Node 5");

    add_edge(edges, num_edges, 1, 2, 10);
    add_edge(edges, num_edges, 1, 3, 5);
    add_edge(edges, num_edges, 2, 4, 2);
    add_edge(edges, num_edges, 3, 4, 7);
    add_edge(edges, num_edges, 4, 5, 3);

    print_nodes(nodes, num_nodes);
    print_edges(edges, num_edges);

    return 0;
}