//LLAMA2-13B DATASET v1.0 Category: Weather simulation ; Style: protected
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_TEMP 40
#define MIN_TEMP 0
#define RAIN_CHANCE 20
#define THUNDERSTORM_CHANCE 10

#define DAY_LENGTH 12
#define DAY_NIGHT 12

typedef struct weather {
    int temperature;
    int humidity;
    int rain;
    int thunderstorm;
} weather_t;

weather_t current_weather;
weather_t forecast[7];

void init_weather() {
    current_weather.temperature = (rand() % MAX_TEMP) + MIN_TEMP;
    current_weather.humidity = (rand() % 100) + 10;
    current_weather.rain = (rand() % RAIN_CHANCE) == 0;
    current_weather.thunderstorm = (rand() % THUNDERSTORM_CHANCE) == 0;
}

void update_weather() {
    current_weather.temperature += (rand() % 5) - 2;
    current_weather.humidity += (rand() % 5) - 2;
    current_weather.rain = (rand() % RAIN_CHANCE) == 0;
    current_weather.thunderstorm = (rand() % THUNDERSTORM_CHANCE) == 0;
}

void print_weather() {
    printf("Current Weather: \n");
    printf("Temperature: %d\n", current_weather.temperature);
    printf("Humidity: %d%%\n", current_weather.humidity);
    printf("Rain: %s\n", current_weather.rain ? "Yes" : "No");
    printf("Thunderstorm: %s\n", current_weather.thunderstorm ? "Yes" : "No");
}

void forecast_weather() {
    for (int i = 0; i < 7; i++) {
        forecast[i].temperature = (rand() % MAX_TEMP) + MIN_TEMP;
        forecast[i].humidity = (rand() % 100) + 10;
        forecast[i].rain = (rand() % RAIN_CHANCE) == 0;
        forecast[i].thunderstorm = (rand() % THUNDERSTORM_CHANCE) == 0;
    }
}

int main() {
    init_weather();
    print_weather();
    forecast_weather();

    for (int i = 0; i < DAY_LENGTH; i++) {
        update_weather();
        print_weather();
        sleep(1);
    }

    for (int i = DAY_LENGTH; i < DAY_NIGHT; i++) {
        update_weather();
        print_weather();
        sleep(1);
    }

    return 0;
}