//GEMINI-pro DATASET v1.0 Category: Movie Rating System ; Style: multivariable
#include <stdio.h>

// Define the movie rating system
typedef enum {
  G,
  PG,
  PG13,
  R,
  NC17
} MovieRating;

// Define the movie genres
typedef enum {
  ACTION,
  ADVENTURE,
  COMEDY,
  DRAMA,
  FANTASY,
  HORROR,
  ROMANCE,
  SCI_FI,
  THRILLER,
  WESTERN
} MovieGenre;

// Define the movie structure
typedef struct {
  char title[50];
  MovieRating rating;
  MovieGenre genre;
  int releaseYear;
} Movie;

// Get the movie rating as a string
const char *getMovieRatingString(MovieRating rating) {
  switch (rating) {
    case G:
      return "G";
    case PG:
      return "PG";
    case PG13:
      return "PG-13";
    case R:
      return "R";
    case NC17:
      return "NC-17";
    default:
      return "Unknown";
  }
}

// Get the movie genre as a string
const char *getMovieGenreString(MovieGenre genre) {
  switch (genre) {
    case ACTION:
      return "Action";
    case ADVENTURE:
      return "Adventure";
    case COMEDY:
      return "Comedy";
    case DRAMA:
      return "Drama";
    case FANTASY:
      return "Fantasy";
    case HORROR:
      return "Horror";
    case ROMANCE:
      return "Romance";
    case SCI_FI:
      return "Sci-Fi";
    case THRILLER:
      return "Thriller";
    case WESTERN:
      return "Western";
    default:
      return "Unknown";
  }
}

// Print the movie details
void printMovieDetails(Movie movie) {
  printf("Title: %s\n", movie.title);
  printf("Rating: %s\n", getMovieRatingString(movie.rating));
  printf("Genre: %s\n", getMovieGenreString(movie.genre));
  printf("Release Year: %d\n", movie.releaseYear);
}

// Main function
int main() {
  // Create a movie
  Movie movie = {
    .title = "The Shawshank Redemption",
    .rating = R,
    .genre = DRAMA,
    .releaseYear = 1994
  };

  // Print the movie details
  printMovieDetails(movie);

  return 0;
}