//Falcon-180B DATASET v1.0 Category: Packet Capturer with pcap library ; Style: futuristic
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <string.h>

#define MAX_PKT_SIZE 65535
#define SNAPLEN 65535
#define TRUE 1
#define FALSE 0

typedef struct {
    u_int8_t *data;
    u_int32_t size;
} Packet;

void process_packet(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    printf("Received packet with size %d\n", header->len);
}

int main(int argc, char *argv[]) {
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;
    char *dev;
    struct bpf_program filter;
    int ret;

    if (argc!= 2) {
        fprintf(stderr, "Usage: %s <device>\n", argv[0]);
        exit(1);
    }

    dev = argv[1];

    /* Open the device */
    handle = pcap_open_live(dev, SNAPLEN, 1, 1000, errbuf);

    if (handle == NULL) {
        fprintf(stderr, "Error opening device %s: %s\n", dev, errbuf);
        exit(1);
    }

    /* Set the filter */
    ret = pcap_compile(handle, &filter, "tcp", 1, PCAP_NETMASK_UNKNOWN);

    if (ret == -1) {
        fprintf(stderr, "Error compiling filter: %s\n", pcap_geterr(handle));
        exit(1);
    }

    /* Set the filter */
    ret = pcap_setfilter(handle, &filter);

    if (ret == -1) {
        fprintf(stderr, "Error setting filter: %s\n", pcap_geterr(handle));
        exit(1);
    }

    /* Start the capture */
    ret = pcap_loop(handle, -1, process_packet, NULL);

    if (ret == -1) {
        fprintf(stderr, "Error capturing packets: %s\n", pcap_geterr(handle));
        exit(1);
    }

    pcap_close(handle);

    return 0;
}