//GPT-4o-mini DATASET v1.0 Category: Secure Password Generator ; Style: visionary
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define PASSWORD_LENGTH 16
#define LOWERCASE "abcdefghijklmnopqrstuvwxyz"
#define UPPERCASE "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
#define DIGITS "0123456789"
#define SPECIAL_CHARACTERS "!@#$%^&*()-_=+[]{}|;:',.<>?/`~"

// Function to generate a random password
void generatePassword(char *password) {
    const char *characterSets[] = {LOWERCASE, UPPERCASE, DIGITS, SPECIAL_CHARACTERS};
    int characterSetSize[] = {strlen(LOWERCASE), strlen(UPPERCASE), strlen(DIGITS), strlen(SPECIAL_CHARACTERS)};
    int totalChars = sizeof(characterSets) / sizeof(characterSets[0]);
    
    // Ensuring our password includes at least one character from each category for strength
    password[0] = characterSets[0][rand() % characterSetSize[0]];
    password[1] = characterSets[1][rand() % characterSetSize[1]];
    password[2] = characterSets[2][rand() % characterSetSize[2]];
    password[3] = characterSets[3][rand() % characterSetSize[3]];
    
    // Fill the remaining part of the password with random choices from all character sets
    for (int i = 4; i < PASSWORD_LENGTH; i++) {
        int randomSet = rand() % totalChars;
        password[i] = characterSets[randomSet][rand() % characterSetSize[randomSet]];
    }
    
    // Shuffle the password to enhance randomness
    for (int i = PASSWORD_LENGTH - 1; i > 0; i--) {
        int j = rand() % (i + 1);
        char temp = password[i];
        password[i] = password[j];
        password[j] = temp;
    }

    // Null terminate the string
    password[PASSWORD_LENGTH] = '\0';
}

// Function to print the generated password
void printPassword(const char *password) {
    printf("Generated Secure Password: %s\n", password);
}

// Main function to execute the password generator
int main() {
    srand(time(NULL));  // Seed the random number generator

    char password[PASSWORD_LENGTH + 1]; // +1 for the null terminator
    generatePassword(password);

    printPassword(password);
    
    return 0;
}