//GEMINI-pro DATASET v1.0 Category: File Encyptor ; Style: scalable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Function to encrypt a file
int encrypt_file(char *filename, char *key){
    // Open the file in read mode
    FILE *input = fopen(filename, "r");
    if (input == NULL){
        printf("Error opening the file.\n");
        return -1;
    }

    // Open a new file in write mode
    char *output_filename = malloc(strlen(filename) + 5);
    strcpy(output_filename, filename);
    strcat(output_filename, ".enc");
    FILE *output = fopen(output_filename, "w");
    if (output == NULL){
        printf("Error opening the output file.\n");
        fclose(input);
        return -1;
    }

    // Get the length of the key
    int key_len = strlen(key);

    // Read the file character by character
    char ch;
    while ((ch = fgetc(input)) != EOF){
        // Encrypt the character using the key
        ch ^= key[ch % key_len];

        // Write the encrypted character to the output file
        fputc(ch, output);
    }

    // Close the files
    fclose(input);
    fclose(output);

    // Free the allocated memory
    free(output_filename);

    return 0;
}

// Function to decrypt a file
int decrypt_file(char *filename, char *key){
    // Open the file in read mode
    FILE *input = fopen(filename, "r");
    if (input == NULL){
        printf("Error opening the file.\n");
        return -1;
    }

    // Open a new file in write mode
    char *output_filename = malloc(strlen(filename) - 4);
    strncpy(output_filename, filename, strlen(filename) - 4);
    FILE *output = fopen(output_filename, "w");
    if (output == NULL){
        printf("Error opening the output file.\n");
        fclose(input);
        return -1;
    }

    // Get the length of the key
    int key_len = strlen(key);

    // Read the file character by character
    char ch;
    while ((ch = fgetc(input)) != EOF){
        // Decrypt the character using the key
        ch ^= key[ch % key_len];

        // Write the decrypted character to the output file
        fputc(ch, output);
    }

    // Close the files
    fclose(input);
    fclose(output);

    // Free the allocated memory
    free(output_filename);

    return 0;
}

int main(){
    // Get the filename and key from the user
    char filename[100], key[100];
    printf("Enter the filename: ");
    scanf("%s", filename);
    printf("Enter the key: ");
    scanf("%s", key);

    // Encrypt the file
    if (encrypt_file(filename, key) == 0){
        printf("File encrypted successfully.\n");
    } else {
        printf("Error encrypting the file.\n");
    }

    // Decrypt the file
    if (decrypt_file(strcat(filename, ".enc"), key) == 0){
        printf("File decrypted successfully.\n");
    } else {
        printf("Error decrypting the file.\n");
    }

    return 0;
}