//Falcon-180B DATASET v1.0 Category: Network Ping Test ; Style: multi-threaded
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>

#define MAX_THREADS 10
#define BUFFER_SIZE 1024

pthread_t threads[MAX_THREADS];
int thread_count = 0;

void *ping_thread(void *arg) {
    char *ip = (char *) arg;
    int sockfd, ret;
    struct sockaddr_in serveraddr;
    char buffer[BUFFER_SIZE];

    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == -1) {
        perror("socket");
        exit(EXIT_FAILURE);
    }

    serveraddr.sin_family = AF_INET;
    serveraddr.sin_addr.s_addr = inet_addr(ip);
    serveraddr.sin_port = htons(7);

    ret = connect(sockfd, (struct sockaddr *) &serveraddr, sizeof(serveraddr));
    if (ret == -1) {
        perror("connect");
        exit(EXIT_FAILURE);
    }

    ret = send(sockfd, "PING", strlen("PING"), 0);
    if (ret == -1) {
        perror("send");
        exit(EXIT_FAILURE);
    }

    ret = recv(sockfd, buffer, BUFFER_SIZE, 0);
    if (ret == -1) {
        perror("recv");
        exit(EXIT_FAILURE);
    }

    printf("Response from %s: %s\n", ip, buffer);

    close(sockfd);

    return NULL;
}

int main() {
    int thread_id;
    char *ips[] = {"127.0.0.1", "8.8.8.8", "192.168.1.1"};
    int num_ips = sizeof(ips) / sizeof(ips[0]);

    for (int i = 0; i < num_ips; i++) {
        thread_id = thread_count++;
        if (thread_id >= MAX_THREADS) {
            thread_id = 0;
        }
        pthread_create(&threads[thread_id], NULL, ping_thread, (void *)ips[i]);
    }

    for (int i = 0; i < thread_count; i++) {
        pthread_join(threads[i], NULL);
    }

    return 0;
}