//Falcon2-11B DATASET v1.0 Category: Building a POP3 Client ; Style: real-life
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>

// Function to create a socket
int create_socket() {
    int socket_desc = socket(AF_INET, SOCK_STREAM, 0);
    if (socket_desc < 0) {
        perror("Socket creation error");
        exit(EXIT_FAILURE);
    }
    return socket_desc;
}

// Function to establish a connection with a server
int establish_connection(int socket_desc, const char* server_ip, const char* server_port) {
    struct sockaddr_in server_address;
    memset(&server_address, 0, sizeof(server_address));
    server_address.sin_family = AF_INET;
    server_address.sin_port = htons(atoi(server_port));
    server_address.sin_addr.s_addr = inet_addr(server_ip);

    int connect_result = connect(socket_desc, (struct sockaddr*)&server_address, sizeof(server_address));
    if (connect_result < 0) {
        perror("Connection failed");
        exit(EXIT_FAILURE);
    }

    return 1;
}

// Function to send a message to the server
int send_message(int socket_desc, const char* message) {
    int bytes_sent = send(socket_desc, message, strlen(message), 0);
    if (bytes_sent < 0) {
        perror("Send message failed");
        exit(EXIT_FAILURE);
    }
    return 1;
}

// Function to receive a message from the server
int receive_message(int socket_desc, char* buffer, int buffer_size) {
    int bytes_received = recv(socket_desc, buffer, buffer_size, 0);
    if (bytes_received < 0) {
        perror("Receive message failed");
        exit(EXIT_FAILURE);
    }
    return 1;
}

int main() {
    int socket_desc = create_socket();
    if (socket_desc < 0) {
        perror("Socket creation failed");
        exit(EXIT_FAILURE);
    }

    const char* server_ip = "mail.example.com";
    const char* server_port = "110";

    if (establish_connection(socket_desc, server_ip, server_port) == 0) {
        perror("Connection failed");
        exit(EXIT_FAILURE);
    }

    char buffer[100];
    int bytes_received = receive_message(socket_desc, buffer, sizeof(buffer));
    if (bytes_received < 0) {
        perror("Receive message failed");
        exit(EXIT_FAILURE);
    }

    printf("Received message: %s\n", buffer);

    char* message = "USER username\r\n";
    if (send_message(socket_desc, message) == 0) {
        perror("Send message failed");
        exit(EXIT_FAILURE);
    }

    message = "PASS password\r\n";
    if (send_message(socket_desc, message) == 0) {
        perror("Send message failed");
        exit(EXIT_FAILURE);
    }

    message = "CAPA\r\n";
    if (send_message(socket_desc, message) == 0) {
        perror("Send message failed");
        exit(EXIT_FAILURE);
    }

    message = "STAT\r\n";
    if (send_message(socket_desc, message) == 0) {
        perror("Send message failed");
        exit(EXIT_FAILURE);
    }

    bytes_received = receive_message(socket_desc, buffer, sizeof(buffer));
    if (bytes_received < 0) {
        perror("Receive message failed");
        exit(EXIT_FAILURE);
    }

    printf("Received message: %s\n", buffer);

    close(socket_desc);

    return 0;
}