//Falcon-180B DATASET v1.0 Category: Database querying ; Style: visionary
#include <stdio.h>
#include <stdlib.h>

#define MAX_ENTRIES 100
#define MAX_NAME_LEN 50
#define MAX_PHONE_LEN 20

typedef struct {
    char name[MAX_NAME_LEN];
    char phone[MAX_PHONE_LEN];
} contact_t;

contact_t contacts[MAX_ENTRIES];
int num_contacts = 0;

void add_contact(contact_t *c) {
    if (num_contacts >= MAX_ENTRIES) {
        printf("Error: Contact database is full.\n");
        return;
    }
    strcpy(contacts[num_contacts].name, c->name);
    strcpy(contacts[num_contacts].phone, c->phone);
    num_contacts++;
}

void print_contacts() {
    printf("Name\tPhone\n");
    for (int i = 0; i < num_contacts; i++) {
        printf("%s\t%s\n", contacts[i].name, contacts[i].phone);
    }
}

void search_contacts(char *query) {
    for (int i = 0; i < num_contacts; i++) {
        if (strstr(contacts[i].name, query) || strstr(contacts[i].phone, query)) {
            printf("Name: %s\nPhone: %s\n", contacts[i].name, contacts[i].phone);
        }
    }
}

int main() {
    contact_t c1 = {"John Doe", "555-1234"};
    contact_t c2 = {"Jane Smith", "555-5678"};
    contact_t c3 = {"Bob Johnson", "555-9012"};

    add_contact(&c1);
    add_contact(&c2);
    add_contact(&c3);

    print_contacts();

    search_contacts("John");

    return 0;
}